import * as React from 'react';
import { cn } from '@/lib/utils';

function Button({
  className,
  children,
  ...props
}: React.ComponentProps<'button'> & { className?: string }) {
  return (
    <div className="group relative inline-block size-20 [--offset:0px] has-active:[--offset:4px]">
      <span className="absolute top-1 left-1 z-0 size-full scale-98 rounded-full bg-black transition-all" />
      <button
        data-slot="button"
        className={cn(
          'relative top-[var(--offset,0px)] left-[var(--offset,0px)] z-10 size-20 rounded-full border border-red-500 bg-red-500 text-white transition-all',
          className,
        )}
        {...props}
      >
        {children}
      </button>
    </div>
  );
}

export { Button };
